import random, time

class Die:

	def __init__(self, sides=6):
		try: self.sides = range(1,sides+1)
		except TypeError: self.sides = list(sides)

	def roll(self, times=1):
		t = time.time()
		random.seed(t)
		total = 0
		for i in range(1,times+1):
			roll = random.choice(self.sides)
			total+=roll
		return total

class DiceBag:

	def __init__(self):
		self.d4 = Die(4)
		self.d6 = Die(6)
		self.d8 = Die(8)
		self.d10 = Die(10)
		self.d12 = Die(12)
		self.d20 = Die(20)
		self.d100 = Die(100)
