import os, sys
import pygame
from pygame.locals import *
import config

class Display:

	def __init__(self):

		# Center window on screen
		os.environ['SDL_VIDEO_CENTERED'] = '1'

		# Initialize PyGame
		pygame.init()

		# Read the config file and set the display to window or fullscreen
		if config.fullscreen is 1:
			fs = FULLSCREEN
		else:
			fs = 0
		self.screen = pygame.display.set_mode(config.screen_size, fs, config.color_depth)

		# Read config file and set the window caption
		pygame.display.set_caption(config.game_name)

		# Disable the mouse cursor
		pygame.mouse.set_visible(0)

		# Create a game clock used to control the framerate
		self.clock = pygame.time.Clock()
