import os, sys
import pygame
from pygame.locals import *
import config
from data import *
from display import Display
from scene import Scene

class Game:

	def __init__(self):

		# Create a screen to draw to
		self.display = Display()

		# When the game starts, show the default scene (the demo for now)
		self.show_scene()


	def show_scene(self, sceneid=0):
	# Load a game scene

		self.scene = Scene(self.display.screen, sceneid)

		# This is the main game loop.
		while 1:

			# Limit the game's framerate
			self.display.clock.tick(config.frame_speed)

			# Draw the scene to the screen
			self.scene.draw()

			# Check for user input and trigger the scene events
			self.scene.event_check()

			# Debug: Print framerate to window title
			if pygame.time.get_ticks() % 1000 == 0:
				pygame.display.set_caption('framerate: %02d/%02d' % (self.display.clock.get_fps(), config.frame_speed))
				#print 'framerate: %02d/%02d' % (self.display.clock.get_fps(), config.frame_speed)
