import os, sys
import iniparse
import pygame
from pygame.locals import *
import config
from data import *
from dice import DiceBag

class Player(pygame.sprite.DirtySprite):

	def __init__(self, screen, background, foreground, scrollpos, start, nowalk, danger):
		pygame.sprite.DirtySprite.__init__(self)
		self.dirty = 2
		self.screen = screen
		self.background = background
		self.foreground = foreground
		self.tiles_nowalk = nowalk
		self.tiles_danger = danger
		self.move = 0
		self.move_keys = []
		self.collide = {}
		self.running = False
		self.width = 32
		self.height = 32
		self.scrollpos = scrollpos
		self.animcounter = 0

		# Define the player sprite file
		self.sprite = load_sprite('player.png')

		# Position the player facing south at the map's start location
		self.frame = 0
		self.x = self.width * start[0] + self.scrollpos[0]
		self.y = self.height * start[1] + self.scrollpos[1] + 8

		# Define the various frames within the player's spritesheet
		self.north = self.sprite.images([ \
			(0, 0, self.width, self.height),		# Frame 0: North1
			(32, 0, self.width, self.height),		# Frame 1: North2
			(64, 0, self.width, self.height),		# Frame 2: North3
			(96, 0, self.width, self.height)		# Frame 3: North4
		],((255,0,255)))
		self.south = self.sprite.images([ \
			(0, 64, self.width, self.height),		# Frame 0: South1
			(32, 64, self.width, self.height),		# Frame 1: South2
			(64, 64, self.width, self.height),		# Frame 2: South3
			(96, 64, self.width, self.height)		# Frame 3: South4
		],((255,0,255)))
		self.east = self.sprite.images([ \
			(0, 32, self.width, self.height),		# Frame 0: East1
			(32, 32, self.width, self.height),		# Frame 1: East2
			(64, 32, self.width, self.height),		# Frame 2: East3
			(96, 32, self.width, self.height)		# Frame 3: East4
		],((255,0,255)))
		self.west = self.sprite.images([ \
			(0, 96, self.width, self.height),		# Frame 0: West1
			(32, 96, self.width, self.height),		# Frame 1: West2
			(64, 96, self.width, self.height),		# Frame 2: West3
			(96, 96, self.width, self.height)		# Frame 3: West4
		],((255,0,255)))
		self.walking = { 0: self.south, 'up': self.north, 'down': self.south, 'right': self.east, 'left': self.west }

		# Create the sprite
		self.image = self.south[self.frame]
		self.rect = self.image.get_rect(left=self.x, top=self.y)
		self.collide_surface = pygame.Surface((self.width/2,self.height/4))
		self.collide_rect = self.collide_surface.get_rect(centerx=self.rect.centerx+1, bottom=self.rect.bottom)

		# Create some dice for randomness
		self.dice = DiceBag()

		# Keep track of spaces moved for random encounter checks
		self.current_space = 0

		# Random encounter check after this many spaces moved
		self.spaces = 4

	def update(self):

		direction = self.move
		self.movement = 1
		self.animspeed = 10

		def move():

			# Player moves faster when running
			if self.running:
				self.movement*=2
				self.animspeed/=2

			# Move the player up
			if direction == 'up':
				if self.collide[direction] is False:
					if self.rect.centery < config.screen_size[1]/3 and self.scrollpos[1] < 0:
						self.scrollpos[1]+=self.movement
					else:
						self.rect.move_ip(0,-self.movement)

			# Move the player down
			if direction  == 'down':
				if self.collide[direction] is False:
					if self.rect.centery > config.screen_size[1] - (config.screen_size[1]/3) and self.background.get().get_height()+self.scrollpos[1] > config.screen_size[1]:
						self.scrollpos[1]-=self.movement
					else:
						self.rect.move_ip(0,self.movement)

			# Move the player left
			if direction == 'left':
				if self.collide[direction] is False:
					if self.rect.centerx < config.screen_size[0]/3 and self.scrollpos[0] < 0:
						self.scrollpos[0]+=self.movement
					else:
						self.rect.move_ip(-self.movement,0)

			# Move the player right
			if direction == 'right':
				if self.collide[direction] is False:
					if self.rect.centerx > config.screen_size[0] - (config.screen_size[0]/3) and self.background.get().get_width()+self.scrollpos[0] > config.screen_size[0]:
						self.scrollpos[0]-=self.movement
					else:
						self.rect.move_ip(self.movement,0)

			# Show animation frames
			self.animcounter = (self.animcounter + 1)%self.animspeed
			if self.animcounter == 0:
				self.frame = (self.frame + 1)%len(self.walking[direction])

			# Update and draw the new location
			self.image = self.walking[direction][self.frame]
			self.collide_rect.centerx = self.rect.left+self.collide_rect.width-self.scrollpos[0]
			self.collide_rect.bottom = self.rect.bottom-self.scrollpos[1]

		# If a direction key was pressed and the tile is walkable, move the player there
		if direction:
			self.collide_check()
			if not self.collide[direction]:
				move()
				self.encounter_check()

	def collide_check(self):

		# Check each direction for unwalkable tiles
		check = {
			'up': self.collide_rect.move(0,-1),
			'down': self.collide_rect.move(0,1),
			'left': self.collide_rect.move(-1,0),
			'right': self.collide_rect.move(1,0)
		}
		for key, rect in check.iteritems():
			if not pygame.Rect(rect).collidelistall(self.tiles_nowalk) == []:
				self.collide[key] = True
			else:
				self.collide[key] = False

	def encounter_check(self):

		# number of spaces to move before checking
		spaces = self.spaces

		# If the space is dangerous, double chance of an encounter
		if not pygame.Rect(self.rect.left,self.rect.top,self.width,self.height).collidelistall(self.tiles_danger) == []:
			spaces = spaces/2

		# Check for encounters
		self.current_space+=1
		if self.current_space == spaces:
			if self.dice.d6.roll() == 6:
				print "Random encounter occured"
			self.current_space = 0
