import os, sys, random
import pygame
from pygame.locals import *
import config
from data import *
from map import Map
from player import Player

class Scene:

	def __init__(self, screen, sceneid):

		# Load the map
		self.sceneid = sceneid
		self.map = Map(sceneid, screen)

		# Create and draw the player at the map's start location
		self.player = Player(screen, self.map.background, self.map.foreground, self.map.scrollpos, self.map.start_tile, self.map.nowalk, self.map.danger)

		# Some needed data
		self.fullscreen = config.fullscreen
		self.screen = screen

		# Draw everything when when the scene is first loaded
		pygame.display.update()

		self.render = pygame.sprite.LayeredDirty()
		self.render.add(self.map.background)
		self.render.add(self.player)
		self.render.add(self.map.foreground)

		# Start playing the scene's music
		# TODO: Audio system
		#load_music(music)
		#pygame.mixer.music.play()

	def draw(self):

		# Draw the player
		self.render.update()
		self.render.draw(self.screen)
		pygame.display.update()

		# Debug: Show player rectangle as black and collidable tiles as white
		#self.map.background.fill((0,0,0), self.player.collide_rect)
		#for i in (self.player.tiles_nowalk):
		#	self.map.background.fill((255,255,255), i)

	def event_check(self):

		# Check and respond to user input
		for event in pygame.event.get():

			# Quit game when window is closed
			if event.type == QUIT:
				sys.exit(0)

			if event.type == KEYDOWN:

				# Go back to the main menu when Escape is pressed
				if event.key == K_ESCAPE:
					sys.exit(0)

				# Hold left CTRL key to run
				if event.key == K_LCTRL:
					self.player.running = True

				# Toggle fullscreen when F is pressed
				if event.key == K_f:
					if self.fullscreen is 1:
						pygame.display.set_mode(config.screen_size, 0, config.color_depth)
						self.fullscreen = 0
						self.map.player.draw()
					else:
						pygame.display.set_mode(config.screen_size, FULLSCREEN, config.color_depth)
						self.fullscreen = 1
						self.map.player.draw()

				# Move the player when a direction key is pressed
				if event.key in (K_UP, K_DOWN, K_LEFT, K_RIGHT):
					self.player.move_keys.append(pygame.key.name(event.key))
					dir = self.player.move_keys[-1]
					self.player.move = dir

			if event.type == KEYUP:

				# Stop running when left CTRL key is released
				if event.key == K_LCTRL:
					self.player.running = False

				# Stop moving the player when the direction key is released
				if event.key in (K_UP, K_DOWN, K_LEFT, K_RIGHT):
					keyid = self.player.move_keys.index(pygame.key.name(event.key))
					del self.player.move_keys[keyid]
					if not len(self.player.move_keys) == 0:
						dir = self.player.move_keys[-1]
						self.player.move = dir
					else:
						self.player.move = 0
