import os,sys,random,time
import pygame
from pygame.locals import *

from colors import *
from script_reader import *

GRID_SIZE = 25

def load_image(name,colorkey = None):
    try:
        image = pygame.image.load(name)
    except pygame.error, message:
        print "L'immagine",name,"non puo' essere caricata"
        raise SystemExit, message
    image = image.convert()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey,RLEACCEL)
    return image,image.get_rect()

def load_sound(name):
    
    class NessunSuono:
        def play(self): pass
    if not pygame.mixer:
        return NessunSuono()
    try:
        sound = pygame.mixer.Sound(name)
    except pygame.error,message:
        print "Il suono",name,"non puo' essere caricato"
        raise SystemExit,message
    return sound

def Background(screen,img):
    bgdtile = pygame.image.load(os.path.join(MODULO,'img',img)).convert()
    background = pygame.Surface(SCREEN.size)
    for x in range(0,SCREEN.height, bgdtile.get_width()):
        for y in range(0,SCREEN.width,bgdtile.get_height()):
            background.blit(bgdtile, (y, x))
    return background

def SetBackground(screen,bg):
    screen.blit(bg, (0,0))

def Title(bg,msg,nome = 'verdana.ttf',size = 20,color = black):
    font = pygame.font.Font(os.path.join(MODULO,'font',nome),size)
    testo = font.render(msg,1,color)
    pos = testo.get_rect()
    pos.centerx = bg.get_rect().centerx
    bg.blit(testo,pos)

def set_point(x,y):
    return (x*25,y*25);

class Immobile:
    
    def is_immobile(self):
        return 1

class Mobile:

    def is_immobile(self):
        return 0

class onWalk:
    def __init__(self,script_name):
        self.scrip = scriptname

    def on_Walk(self):
        return 1

class onPress:
    def __init__(self,script_name):
        self.scrip = scriptname

    def on_Press(self):
        return 1

class noEvent:
    def __init__(self):
        pass

    def on_Walk(self):
        return 0

    def on_Press(self):
        return 0

class Vuoto(pygame.sprite.Sprite,Immobile,onWalk,onPress):
    def __init__(self):
        pygame.sprite.Sprite.__init__(self)
    
class Muro(Immobile,onPress):

    def __init__(self,bg,x,y):
        self.img,self.rect = load_image(os.path.join(MODULO,'img','muro.bmp'))
        bg.blit(self.img,(x,y))

class PNG(pygame.sprite.Sprite,Mobile,onPress):

    def __init__(self,image):
        pygame.sprite.Sprite.__init__(self)
        self.img,self.rect = load_image(os.path.join(MODULO,'img',image),-1)

    def set_pos(self,bg,pos):
        bg.blit(self.img,pos)

    def update(self):
        x = random.randint(-1,1)
        y = random.randint(-1,1)
        self.rect.move_ip(x,y)
        

class Eroe(pygame.sprite.Sprite,Mobile):

    def __init__(self,bg,image,x,y):
        pygame.sprite.Sprite.__init__(self)
        self.img,self.rect = load_image(os.path.join(MODULO,'img',image),-1)
        bg.blit(self.img,(x,y))

class game:
    
    def __init__(self):
        self.map,self.script = read_module(MODULO)
        #Aggiungere variabili di gioco
        self.playing = 1
        #----
        self.layout = 0
        self.script = 0
        
    def start(self):
        pygame.init()
        self.schermo = pygame.display.set_mode(SCREEN.size)
        pygame.display.set_caption('pyRPG Maker ver 0.0.0.1')
        pygame.mouse.set_visible = 0
        bg = Background(self.schermo,'prato.bmp')
        self.read_map(bg)
        #Title(bg,'Hello')
        SetBackground(self.schermo,bg)
        #pygaem.display.update()
        pygame.display.flip()

    def play(self):
        time.sleep(0.05)

    def read_map(self,surface):
        y=0
        for a in self.map:
            x=0
            for char in a:
                if char == '%':
                    Muro(surface,x,y)
                elif char == 'P':
                    self.png = PNG('png.bmp')
                    self.png.set_pos(surface,(x,y))
                elif char == 'E':
                    Eroe(surface,'eroe.bmp',x,y)
                elif char == " ":
                    pass
                x += GRID_SIZE
            y += GRID_SIZE
       
if not pygame.font: print 'Attenzione: Font Disabilitati'
if not pygame.mixer: print 'Attenzione: Suono Disabilitato'

SCREEN = Rect(0,0,800,600)
MODULO = 'modulo1'

g = game()
g.start()
#while g.playing:
#    g.play()
#test
raw_input('Enter to exit')
