# src code best viewed with tabspace set to 4

import pygame, sys, string
from pygame.locals import *

class Screen:
	def __init__(self,size=(320,200)):
		self.size=size
		self.surface=pygame.display.set_mode(self.size)
		
	def scroll(self,map,pos):
		''' give me the map instance and a position and I'll render it '''
		xs=pos[0]/map.tilesize
		ys=pos[1]/map.tilesize		
		numoftiles=((self.size[0]/map.tilesize,self.size[1]/map.tilesize))
		xoffset=-((pos[0]%map.tilesize))
		yoffset=-((pos[1]%map.tilesize))	
		for x in range(numoftiles[0]+2):
			for y in range(numoftiles[1]+2):
				self.surface.blit(map.getTile(xs+x,ys+y), (xoffset+x*map.tilesize,yoffset+y*map.tilesize))
		pygame.display.flip()
		
class Map:
	''' Class for handling map files'''
	def __init__(self,filename,tilesize):
		''' this loads the mapfile and init some vars'''
		self.tiles={}
		self.tilesize=tilesize
		self.nullTile=pygame.Surface((tilesize,tilesize))
		self.data=map( string.split, open(filename,'r') )
		
	def setTiles(self,tiles):
		''' sets the ascii to filename mapping '''
		for char,filename in tiles.items():
			self.tiles[char]=pygame.image.load(filename).convert()
						
	def getTile(self,x,y):
		''' returns the map tile surface (or black surface on error)'''
		try: 
			char=self.data[y][x]
			return self.tiles[char]
		except: 
			return self.nullTile

def main():
	# init screen and map:
	screen=Screen((320,200))
	myMap=Map('mapa1.txt',48)
	myMap.setTiles({
		'.': 'tiles/grass.png',
		'o': 'tiles/mud.png',
		'I': 'tiles/tree_bottom.png',
		'@': 'tiles/tree_top.png'})

	pygame.event.set_grab(1)					# grab mouse/key events
	pygame.mouse.set_visible(0)					# make cursor invisible
	x=y=0
	while 1:
		pygame.event.get()						# get events
		pressed=pygame.key.get_pressed()		# get a list of pressed keys
		offset=pygame.mouse.get_rel()			# get mouse offset from last frame
		
		if offset != (0,0):						# if there was any offset:
			x=max(0,x-offset[0])				# increment x with mouse offset
			y=max(0,y-offset[1])				# increment y with mouse offset			
		screen.scroll(myMap,(x,y))				# render map at new position

			
		if pressed[K_ESCAPE]: 					# if ESC pressed is pressed
			pygame.event.set_grab(0)			# ungrab key/mouse input
			pygame.mouse.set_visible(1)			# make mouse cursor visible
			sys.exit()							# exit

if __name__ == '__main__': main()
