#!/usr/bin/env python
#
#       Game.py
#       
#       Copyright 2009  <yanom@yanom-desktop>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.



import pygame, random
from pygame.locals import *
screen = pygame.display.set_mode((800, 600))
clock = pygame.time.Clock() #make clock obj. regulates framerate.
towersGroup = pygame.sprite.Group()  #stores the game objs.
enemiesGroup = pygame.sprite.Group() #ditto



pygame.font.init() #init... pygame.font.... lol

class Basicsprite(pygame.sprite.Sprite): #create a sprite class
    def __init__(self, img):
        pygame.sprite.Sprite.__init__(self)
        self.image = pygame.image.load(img).convert_alpha()
        self.rect = self.image.get_rect()

class EnemyThingie(Basicsprite): # move, take dmg
	def __init__(self, img, xstartpos, ystartpos, xspeed, yspeed): 
		Basicsprite.__init__(self, img) #<sarcasm> Oh! I've never seen this before! </sarcasm>
		self.rect.left = xstartpos #
		self.rect.top = ystartpos  # put it at its starting coords
		self.speedx = xspeed
		self.speedy = yspeed
	def moveEnemyThingie(self):
		self.rect.left = self.rect.left + self.speedx  #
		self.rect.top = self.rect.top + self.speedy    # add the speeds.
#
class Tower(Basicsprite): #tower for tower def. game
	def __init__(self, img,x,y, beamcolor): #beams have dif colors based on what they are
		Basicsprite.__init__(self, img)
		self.rect.left = x
		self.rect.top = y
		self.bc = beamcolor
		self.hp = 1
	def shoot(self,  surface, objectslist, towerslist, nullvariableThree): 
		target = random.choice(objectslist.sprites()) #pick a target from the list of enemies and laser it.
		target.kill() #destroy selected enemy
		pygame.draw.line(surface, self.bc, (self.rect.left+16, self.rect.top+16), (target.rect.left+16, target.rect.top+16)) #draw a line from self's coords to target's
		#below code makes the tower take damage if it's touching EnemyThingies
		for item in objectslist:
			if self.rect.colliderect(item.rect):
				self.hp = self.hp - 1
			elif self.hp < 1:
				self.kill()

class Boom(Basicsprite): #go boom!
	def __init__(self, img, x, y):
		Basicsprite.__init__(self, img)
		self.rect.left = x
		self.rect.top = y
		self.crect = pygame.rect.Rect((self.rect.left-32, self.rect.top-32),(80,80))
		
	def shoot(self, nullvarTwo, objectslist, towerslist, nullvariableThree):
		for item in objectslist:
			if item.rect.colliderect(self.crect): #collide with the collision rect, crect?
				item.kill()
		self.kill() #booms.... go..... boom....
		
class MegaBoom(Basicsprite): #even bigger boom!
	def __init__(self, img, x, y):
		Basicsprite.__init__(self, img)
		self.rect.left = x
		self.rect.top = y
		self.crect = pygame.rect.Rect((self.rect.left-128, self.rect.top-128),(272,272))
		
	def shoot(self, nullvarTwo, objectslist, towerslist, nullvariableThree):
		for item in objectslist:
			if item.rect.colliderect(self.crect): #collide with the collision rect, crect? (get it? correct? crect?)
				item.kill()
		self.kill() #booms.... go..... boom....


class BoomTower(Basicsprite): #launches BOOM!'s
	def __init__(self, img, x, y):
		Basicsprite.__init__(self, img)
		self.rect.left = x
		self.rect.top = y
		#self.crect = pygame.rect.Rect((self.rect.left-512, self.rect.top-512),(1040,1040)) #has crect like BOOM!'s, but used diffrently
	def shoot(self,  surface, objectslist, towerslist, tick): #jeez lotsa variables. tick is for timing
		if tick == 3: #once every cycle of 10, y not 3?
			target = random.choice(objectslist.sprites())
			towerslist.add(Boom("boom.png", target.rect.left, target.rect.top))
			pygame.draw.line(surface, (255,0,0), (self.rect.left+32, self.rect.top+32), (target.rect.left, target.rect.top), 8)




def main(EnemiesPerFrame): #EPF is initial value: it increases over time
	money = 0  #variables used ingame
	points = 0
	counter = 0
	
	for x in xrange(0, 12): #12 towers on screen
		towersGroup.add(Tower("donut.png", random.randint(100, (screen.get_width()-32)),  random.randint(100, (screen.get_height()-32)),(random.randint(50,255),random.randint(50,255),random.randint(50,255))))
	
	
	
	perframe = EnemiesPerFrame
	enemiesGroup.add(EnemyThingie("enemy.png", random.randint(-100, 100),random.randint(0, 400), 4, 0))  #this error gets raised if the game isn't started  with one enemy in the enemieslist group
	
	gameFont = pygame.font.SysFont("Monospace", 20)
	
	tik = 1 #used as timer
	
	while 1:
		clock.tick(10) #framerate limiter
		
		tik = tik + 1
		if tik >= 10:
			tik = 1
		
		if points < 0: #game over!
			while 1:
				screen.fill((0,0,0))
				for event in pygame.event.get():
					if event.type == KEYDOWN:
						exit()
				screen.blit(gameFont.render("GAME OVER, press any key to exit", False, (255,255,255)), (screen.get_width()/2, 0)) #game over msg
				pygame.display.flip()
		
		if counter > 1000: #counter indicates its time for nxt lvl
			counter = 0 #reset
			perframe = perframe + 1
		
		for event in pygame.event.get():
			if event.type == KEYDOWN and event.key == K_ESCAPE:
				exit()
			if event.type == KEYDOWN and event.key == K_SPACE and money > 1000: #place new tower
				towersGroup.add(Tower("donut.png", pygame.mouse.get_pos()[0], pygame.mouse.get_pos()[1],(random.randint(50,255),random.randint(50,255),random.randint(50,255))))
				money = money - 1000
			if event.type == KEYDOWN and event.key == K_LSHIFT and money > 50: #drop a BOOM!
				towersGroup.add(Boom("boom.png", pygame.mouse.get_pos()[0], pygame.mouse.get_pos()[1]))
				money = money - 50
			if event.type == KEYDOWN and event.key == K_TAB and money > 200: # drop a MegaBOOM!
				towersGroup.add(MegaBoom("boom.png", pygame.mouse.get_pos()[0], pygame.mouse.get_pos()[1]))
				money = money - 200
			if event.type == KEYDOWN and event.key ==  K_LALT and money > 7000: # place a Boom tower.
				towersGroup.add(BoomTower("bt.png", pygame.mouse.get_pos()[0], pygame.mouse.get_pos()[1]))
				money = money - 7000
			
			#cheat code
			if event.type == KEYDOWN and event.key == K_k:
				money = money + 7000
			
		for x in range(0, perframe):
			enemiesGroup.add(EnemyThingie("enemy.png", random.randint(-100, 100),random.randint(0, screen.get_height()), 4, 0))
		screen.fill((0,0,0))
		
		#render points, money values
		screen.blit(gameFont.render("money:"+str(money), False, (255,0,0)), (screen.get_width()-400, 0)) #draw text of var money on screen, for obvious reasons
		screen.blit(gameFont.render("points:"+str(points), False, (255,0,0)), (screen.get_width()-200, 0)) #draw text of var points on screen, for obvious reasons
		screen.blit(gameFont.render("level:"+str((perframe-12)), False, (255,0,0)), (screen.get_width()-600, 0)) #draw text of var perframe, subtracting 12 to get a level reading
		#
		towersGroup.draw(screen)
		#lsts = enemiesGroup.sprites() #get a list of spites...
		for item in towersGroup:
			item.shoot(screen, enemiesGroup, towersGroup, tik)
			money = money + 1 # "
			points = points + 1# "
			counter = counter + 1
		enemiesGroup.draw(screen)
		for item in enemiesGroup:
			item.moveEnemyThingie()
			if item.rect.left > screen.get_width() or item.rect.top > screen.get_height():
				points = points - 100
				item.kill()

		pygame.display.flip()
		#/render
		
	return 0

if __name__ == '__main__': main(13)
