#bin/sh
# This script (hopefully) will take the name of a zipped file and 
# unzip it, install the program, and update a program database.


######################################
# This function checks the return from color menu selections ( mainly the buttons)
######################################

Check_Button ()
{
if [ $? != 0 ]; then # quit button was pressed/selected
	exit
else 
	All_Done
fi
}

######################################
# This is the colorized version of which drive and what is the package name
######################################

GET_DRIVE_FILE ()
{
echo "Where on your hard drive is the package located  (DEFAULT /)" >> /tmp/tmpmsg
echo >> /tmp/tmpmsg			
dialog --title "File location" --inputbox "`cat /tmp/tmpmsg`" 20 72 '/' 2> /tmp/reply
PROGPATH="`cat /tmp/reply`"
Check_Button	 		

			
echo "What is the name of the package " >> /tmp/tmpmsg
echo >> /tmp/tmpmsg
			
dialog --title "Package Name" --inputbox "`cat /tmp/tmpmsg`" 20 72  2> /tmp/reply
PROGNAME="`cat /tmp/reply`"
	Check_button
			
# check for the existance of the file requested.  
cd $PROGPATH

if [ ! -f $PROGNAME ]; then
	echo "Can not seem to find $PROGNAME.\
	Sorry try again." >>	/tmp/tmpmsg
	dialog --title "OOPS  File not found" --msgbox "`cat /tmp/tmpmsg`" 20 72
	rm /tmp/tmpmsg
	exit 0;	 
fi
echo "You entered $PROGPATH as the path and $PROGNAME as the program name" > /tmp/tmpmsg
echo "A file named $PROGRAMNAME was found on the specified drive." >> /tmp/tmpmsg
echo >> /tmp/tmpmsg
echo "Is this information correct?" >> /tmp/tmpmsg
dialog --title "Package Information" --yesno "`cat /tmp/tmpmsg`" 20 72
	Check_button

}

####################################
# This function unzips the file into the temporary installation directory
####################################

UNZIP_IT ()
{
zipfile=$PROGPATH$PROGNAME
echo $zipfile
cd $install_file_path
		
tar zxvf $zipfile >$install_file_path"files"
cd $PROGNAME
}

###################################
# This function looks for a configure file and the runs the install
#NOTE have to work in an IMAKE configuration
###################################

CONFIG_PROGRAM ()
{
# check for a config file, if it exists complete the installation.

if [ -f configure ]; then
	echo "Am now configuring the program for your computer" > /tmp/tmpmsg
	dialog --title "Configuring Program" --infobox "`cat /tmp/tmpmsg`" 20 72 4
	configure 	
	echo "Am now creating the biniaries of the program . . . . this may take
	awhile" > /tmp/tmpmsg
	dialog --title "Creating Program" --infobox "`cat /tmp/tmpmsg`" 20 72 4
	make 
	echo "Am now Installing the program on your computer" > /tmp/tmpmsg
	dialog --title "Installing Program" --infobox "`cat /tmp/tmpmsg`" 20 72 4
	make install
else
	echo "No automatic configuration file was found.  Can not proceed!" >>/tmp/tmpmsg
	dialog --title "Oops" --infobox "'cat /tmp/tmpmsg'" 20 74
	exit 0;
fi	
}

#################################
# This function cleans up after an installation (most notabily it removes the 
# distribution files from the drive)
#################################

CLEAN_DRIVE ()
{
# remove temporary installation files

dialog --title "Cleaning drive" --msgbox "Removing temporary installfiles" 14 72
			
rm -rf $install_file_path

# NOTE Should this work like the Slackware distribution, i.e. remove everything
# except documentation and make it's own directory in /usr/doc ?????

dialog --title "Done" --infobox "Installation Completed" 14 72
exit 0;

}

###############################
# This function is called when the user presses the cancel button in a screen
###############################

All_Done ()
{
echo "\n" > /tmp/tmpmsg
	echo "\n" >> /tmp/tmpmsg	
	echo " Alright, I will be here when you decide to install a program" >> /tmp/tmpmsg
    echo "\n" >> /tmp/tmpmsg
    echo " Thank you for using S(imple) L(inux) I(nstallation) and M(aintenance)." >> /tmp/tmpmsg
dialog --title "Skip installation at this time" --msgbox "`cat /tmp/tmpmsg`" 20 74
	rm /tmp/tmpmsg	
	exit 0;	 
}

##############################
#   START OF SCRIPT
##############################
	
#do some housekeeping here
if [ -f "/tmp/tmpmsg" ]; then
   rm /tmp/tmpmsg
fi
 
install_file_path=/usr/src/install_tar/

# cleanup, just for debugging purposes, remove when script is ready to go

if [ -x "$install_file_path" ]; then
	rm -rf $install_file_path
fi

mkdir $install_file_path

cd $install_file_path

touch hold

date > hold


# NOTE: the following command  checks to see if [file SeTcolor exits and is readable] and if
# the script variable [COLOR is set to on ] if both are valid then goto the colorized installation
#  if not goto to the tty installation.


if [ -r /tmp/SeTcolor -o "$COLOR" = "on" ]; then
	while [ 0 ]; do

# NOTE: what about binary files????

	dialog --title "Simple Linux Installation and Maintenance" --menu "SLIM allows you to install \
 any program package you desire.  In addition to installation SLIM provides a method of file \
 maintenance and upgrade that will ensure that all programs that are installed will work \
 correctly. Which option would you like?" 20 73 5 \
 "Binary"	"Install precompiled binaries "\
 "Tarball"	"Install a compressed program "\
 "RPM"	    "Install a RPM package	(i.e. Redhat, Calderia)" \
 "DEB"	    "Install a Debian package" \
 "Skip"	    "Don't install anything right now" 2> /tmp/reply
 
 	if [ $? = 1 -o $? = 255 ]; then
 		REPLY="Skip"
 	else
 		REPLY="`cat /tmp/reply`"
 	fi
	rm -r /tmp/reply


# User wants to install a precompiled binary program

	if [ "$REPLY" = "Binary" ]; then
		GET_DRIVE_FILE
		Check_Button
		cd /
		UNZIP_IT
		All-Done
	fi
	
# User wants to install a tarballed file

	if [ "$REPLY" = "Tarball" ]; then
		GET_DRIVE_FILE
		Check_Button		
		UNZIP_IT
		Check_Button		
		CONFIG_PROGRAM
		Check_Button
		CLEAN_DRIVE    
		All_Done		
	fi	

# User want to install a RPM program

	if [ "$REPLY" = "RPM" ]; then
		dialog --title "RPM Package Installion"	--msgbox "\nThis portion of Slim is not ready yet." 14 72 
		break
	fi		
# User want to install a DEB(ian) file

	if [ "$REPLY" = "DEB" ]; then
		dialog --title "DEB (DEBIAN) Package Installion" --msgbox "\nThis portion of Slim is not readyat this time." 14 72 
		break
	fi		
	
# USER DECIDED TO SKIP THE INSTALLATION

	if [ "$REPLY" = "Skip" ]; then
		All_Done
	 fi
	done
	
	
fi

######################################
# Below is the console version of SLIM
######################################


TTY_GET_DRIVE_FILE ()
{
echo -n "Where on your hard disk does the package exist?" 
	read PROGPATH	
	echo
	echo -n "What is the name of the program?" 
	read PROGNAME	
	
	#CHECK TO SEE IF FILE EXISTS
	cd $PROGPATH
 
# Seeing as all <tarred> file can be extracted in the same way, the only
# thing that has to be checked is if the file exists on the drive specified

	if [ ! -f $PROGNAME ]; then
	    echo "Unable to find "$PROGNAME"
	else
		UNZIPIT
	
	fi
}


cat << EOF
 
Simple Linux Installation and Maintenance
   
SLIM allows you to install any program package that
you desire.  In addition to installation SLIM provides
a method of file maintenance\upgrade that will ensure 
that all programs you install will work correctly the
first time.

This type of file covers both the Slackware distribution
and source files.
		
Below you will find a number of options that you can
select from. 
                 
Which option would you like?" 

1 -- Binary		Install a precompiled program
2 -- GZIPPED	Install a tarrball file (.Z, .TAR .TAR.GZ or TGZ)
3 -- RPM    	Install a RPMed program  (i.e. REDHAT, CALDERA)
4 -- DEB    	Install a DEBIAN program
5 -- SKIP   	Don't install anything right now
	
EOF

echo -n "Which option would you like ( 1-5)? "
read REPLY

if [ "$REPLY" = "1" ]; then
	cat << EOF
	
Pre-compiled Binary Installation

To complete installation a few items need to be known:

EOF


if [ "$REPLY" = "2" ]; then
	cat << EOF
TAR installation

To complete installation we need to know a few things :

EOF
	TTY_GET_DRIVE_FILE

	if [ -f configure ]; then
		 configure
	   	 make
	  	 make install
# remove temporary installation files
		echo "Removing temporary install files"
		rm -rf $install_file_path
		echo "Installation Completed"
	else
	 	echo "No automatic configuration file was found.  Can not proceed!"
	 	 	
	fi
	
fi

	    
if [ "$REPLY" = "3" ]; then
	cat << EOF

RPM Installation

The RPM install portion of this script is not completed at this time.	
	
EOF
	
fi


if [ $REPLY = "4" ]; then
	cat << EOF 
	
DEB Installation
	
The DBM install portion of this script is not completed at this time.
	
EOF
	
	
fi

if [ "$REPLY" = "5" ]; then
	rm -f /tmp/tmpmsg /tmp/reply
	echo "\n" > /tmp/tmpmsg
	
	cat <<EOF
Alright, I will be here when you decide to install a program

Thank you for using S(imple) L(inux) I(nstallation and M(aintenance).
	
	EOF

fi

#done

